implementation module osbitmap


//	Clean object I/O library, version 1.0.2

import StdArray, StdBool, StdChar, StdClass, StdInt, StdFile
import intrface, ospicture


::	Bitmap
	=	OSBitmap !OSBitmap
::	OSBitmap
	=	{	originalSize	:: !(!Int,!Int)		// The size of the bitmap
		,	reSize			:: !(!Int,!Int)		// to store values passed to resizeBitmap
		,	bitmapContents	:: !{#Char}			// The bitmap information
		}

toBitmap :: !OSBitmap -> Bitmap
toBitmap osBitmap = OSBitmap osBitmap

fromBitmap :: !Bitmap -> OSBitmap
fromBitmap (OSBitmap osBitmap) = osBitmap

//	OSreadBitmap reads a bitmap from a file. See page 176 of Programming Windows 95 (Charles Petzold)
OSreadBitmap :: !*File -> (!Bool,!OSBitmap,!*File)
OSreadBitmap file
	# (_, c1,file) = freadc file
	# (ok,c2,file) = freadc file      // read first two bytes
	| not ok || c1<>'B' || c2<>'M'	  // are they "BM"? 
		= (False,noBitmap,file)
	# (_,  fileSize,file)	= freadi file // read file size
	# (_,  _,       file)	= freadi file // skip bfReserved1 & 2
	# (_,  _,       file)	= freadi file // skip bfOffBits
	# (_,  _,       file)	= freadi file // skip biSize
	# (_,  w,       file)	= freadi file // read width
	# (ok1,h,       file)	= freadi file // read height
	# (ok2,         file)	= fseek  file 0 FSeekSet
	| not ok1 || not ok2
		= (False,noBitmap,file)
	# (data,file)			= freads file fileSize
	| size data <> fileSize
		= (False,noBitmap,file)
	| otherwise 
		= (True,{originalSize=(w,h),reSize=(w,h),bitmapContents=data},file)
where
	noBitmap = {originalSize=(0,0),reSize=(0,0),bitmapContents={}}

//	OSgetBitmapSize returns the size of the bitmap.
OSgetBitmapSize :: !OSBitmap -> (!Int,!Int)
OSgetBitmapSize {reSize}
	= reSize

//	OSgetBitmapContent returns the content string of the bitmap
OSgetBitmapContent :: !OSBitmap -> {#Char}
OSgetBitmapContent {bitmapContents}
	= bitmapContents

/*	OSresizeBitmap bitmap (w,h)
		resizes the argument bitmap to the given size.
	It is assumed that w and h are not negative.
*/
OSresizeBitmap :: !(!Int,!Int) !OSBitmap -> OSBitmap
OSresizeBitmap size bitmap
	= {bitmap & reSize=size}

/*	OSdrawBitmap bitmap pos origin pictContext
		draws the argument bitmap with the left top corner at pos, given the current origin and drawing context.
*/
OSdrawBitmap :: !OSBitmap !(!Int,!Int) !(!Int,!Int) !OSPictContext !*OSToolbox -> (!OSPictContext,!*OSToolbox)
OSdrawBitmap {originalSize=(wO,hO),reSize=(wR,hR),bitmapContents} pos=:(px,py) origin=:(ox,oy) pictContext tb
	| wO==wR && hO==hR
		= WinDrawBitmap (px-ox,py-oy) (0,0,wO,hO) bitmapContents (pictContext,tb)
	| otherwise
		= WinDrawResizedBitmap ((0,0),(wO,hO)) (px-ox,py-oy) (wR,hR) bitmapContents (pictContext,tb)
